<?php
	//////////////////////////////////////////////////////////
	//Function: getEnrolmentData							//
	//@param: $arr											//
	//////////////////////////////////////////////////////////
	
	//*********************************************************
	require_once (dirname(__FILE__).'/env/env.php');
	require_once (dirname(__FILE__).'/../common/model/model.api.class.php');
	require_once (dirname(__FILE__).'/../common/conn/mysqli.conn.v1.php');
	global $db, $darkwaa;
	
	/*********************************************************
	Passport class
	*/
	class getAllCompletedResponse{
		
		public $return;
		
	}
	
	class getEnrolmentDataResponse{
		
		public $return;
		
	}

	class getScannedDocumentsResponse{
		
		public $return;
		
	}
	
	class updateEnrolmentStatusResponse{
		
		public $return;
		
	}
	
	class cPassport{
		
		var $site;
		var $period;
		
		public function __construct(){
			
			$this->site = SITE;
			$this->period = PERIOD;
			
		}
		
		public function getEnrolmentData($arr){
			global $db, $darkwaa;

			//instantiate the response class  
			$response = new getEnrolmentDataResponse();
 
			$xmlData = "";
						
			if(is_object($arr)) 	$refno = strtolower($arr->ReferenceId);//Set input paramenters				
			elseif(is_array($arr)) 	$refno = strtolower($arr['ReferenceId']);
			else die('Array : Invalid input!');

			//Set query string
			$sql = $darkwaa->getEnrolmentDateQuery($refno);

			//Execute on successful result
			try{
				
				//Execute Query
				$rs = $db->query($sql);
				
				if (!$rs->IsError() && $rs->size() ){	
					
					//Dom declaration
					$dom = new DomDocument("1.0", "UTF-8");
					
					//1st item
					$applications = $dom->createElement('applications');
					
					while($row = $rs->fetch()) {
						
						$application = $this->__xmlDetail($dom, $row);
						
						//child root node closure
						$applications->appendChild( $application );
						
					}
					
					//Close DOM		
					$dom->appendChild( $applications );
					
					//$xmlData  = utf8_decode($dom->saveXML($dom->documentElement));
					$xmlOutput  = $dom->saveXML();
					
				} else {
					
					$outcomeVal = 'Error Fetching -> refno='.$refno;
					$xmlOutput = $this->__noResult($outcomeVal);
				}
				
			}catch(exception $e){
				
				$outcomeVal = $e->getMessage();
				$xmlOutput = $this->__noResult($outcomeVal);
				
			}			
			
			//echo $xmlOutput;
			$response->return = $xmlOutput;
			return $response;
			
		}
		
		//gives all online applications that have been completed.
		public function getAllCompleted(){
			global $db, $darkwaa;
			
			//instantiate the response class  
			$response = new getAllCompletedResponse();
			
			$xmlData = "";
			
			//Set query string
			$sql = $darkwaa->getAllCompletedQuery();

			//////////////////////////////////////////////////////////////////////////////
			//Execute on successful result
			try{
				
				//Execute Query
				$rs = $db->query($sql);

				if (!$rs->IsError() && $rs->size()){	
					
					//Dom declaration
					$dom = new DomDocument("1.0", "UTF-8");
					
					//1st item
					$applications = $dom->createElement('applications');
					
					while($row = $rs->fetch()) {
						
						//child root node closure
						$ReferenceId = $dom->createElement('ReferenceId');
		
						$applications->appendChild( $dom->createElement('ReferenceId', isset($row['refno'])?strtoupper(($row['refno'])):"" ) );
						
					}
					
					//Close DOM		
					$dom->appendChild( $applications );
					
					//$xmlData  = utf8_decode($dom->saveXML($dom->documentElement));
					$xmlOutput  = $dom->saveXML();
						
					
				} else {
					
					$outcomeVal = 'No Records Available';
					$xmlOutput = $this->__noResult($outcomeVal);
				}
				
			}catch(exception $e){
				
				$outcomeVal = $e->getMessage();
				$xmlOutput = $this->__noResult($outcomeVal);
				
			}
			
			//echo $xmlOutput;
			$response->return = $xmlOutput;
			return $response;
		}
		
		//get one document belonging to an applicant
		public function getScannedDocuments($arr){
			global $db, $darkwaa;
			
			//instantiate the response class  
			$response = new getScannedDocumentsResponse();
			
			$xmlData = "";
			
			//Set input paramenters
			if(is_object($arr)){
				//Set input paramenters
				$refno 		= strtolower($arr->ReferenceId);
				$documentId = strtolower($arr->documentId);
				
			}elseif(is_array($arr)){
				
				//Set input paramenters
				$refno 		= strtolower($arr['ReferenceId']);
				$documentId = strtolower($arr['documentId']);
			
			}else die('Array : Invalid input!');
			
			//Prepare Query
			$sql = $darkwaa->getScannedDocumentsQuery([$refno, $documentId]);
			//////////////////////////////////////////////////////////////////////////////
			
			try{
				
				//Execute Query
				$rs = $db->query($sql);
				
				//Check query reults
				if ($rs==false) $outcomeVal = 'failed';	
				else $outcomeVal = 'successful';
				
			}catch(exception $e){
				
				$outcomeVal = $e->getMessage();
				
			}
			
			$response->return = $this->__noResult($outcomeVal);
			return $response;
			
		}

		//updateEnrolmentStatus
		public function updateEnrolmentStatus($arr){
			global $db, $darkwaa;
			
			//instantiate the response class  
			$response = new updateEnrolmentStatusResponse();
			
			//Set update date

			$prefetchdate =  date("Y-m-d H:i:s") ;
			
			$xmlData = "";
			
			if(is_object($arr)){
				//Set input paramenters
				$refno 		= $arr->ReferenceId;
				$status 	= $arr->Status;
				$remarks 	= $arr->Remarks;
				
			}elseif(is_array($arr)){
				
				//Set input paramenters
				$refno 		= $arr['ReferenceId'] ;
				$status 	= $arr['Status'] ;
				$remarks 	= $arr['Remarks'];
			
			}else die('Array : Invalid input!');
			
			// Set query string
			$sql = $darkwaa->updateEnrolmentStatusQuery([$refno, $status, $remarks, $prefetchdate]);

			//Execute on successful result
			try{
				
				//Execute Query
				$rs = $db->query($sql);

				if (!$rs->IsError() && $rs->affectedrows() !=0) $outcomeVal = 'successful' ;	
				else $outcomeVal = "Failed - SQL:{$sql}" ;					
				
			}catch(exception $e){
				
				$outcomeVal = $e->getMessage();
				
			}
			
			$response->return = $this->__noResult($outcomeVal);
			return $response;
				
		}
		/////////////////////////////////////////////////////////////////////////////////////
		//////////////////////////// End of Function ////////////////////////////////////////
		/////////////////////////////////////////////////////////////////////////////////////
		
		//Transformation
		protected function __xmlDetail($dom, $row){//1st item
			
			$application = $dom->createElement('application');
		
			// set it's attribute
			$application->setAttribute('ReferenceId', isset($row['refno'])?strtoupper($row['refno']):""); 
			
			//2st item
			$personaldataghana = $dom->createElement('DemographicData');
			
			// set it's attribute
			//$application->setAttribute('applicationId', isset($row['refno'])?strtoupper($row['refno']):"");
			$personaldataghana->appendChild( $dom->createElement('Surname', isset($row['lname'])?ucfirst(($row['lname'])):"" ) );
			$personaldataghana->appendChild( $dom->createElement('FirstName', isset($row['fname'])?ucfirst($row['fname']):"" ) );
			
			$personaldataghana->appendChild( $dom->createElement('OtherNames', isset($row['othername'])?ucfirst($row['othername']):"" ) );
			$personaldataghana->appendChild( $dom->createElement('MaidenNames', isset($row['maidenname'])?ucfirst($row['maidenname']):"" ) );
			$personaldataghana->appendChild( $dom->createElement('PreviousNames', isset($row['pname'])?ucfirst($row['pname']):"" ) );
			
			$personaldataghana->appendChild( $dom->createElement('BirthDate', isset($row['birthdate'])?strtoupper($this->__date($row['birthdate'])):"" ) );
			$personaldataghana->appendChild( $dom->createElement('BirthCity', isset($row['birthplace'])?ucfirst($row['birthplace']):"" ) );
			$personaldataghana->appendChild( $dom->createElement('BirthCountry', strtoupper($this->getDesc($row['birthcountryid'], 'country_tb', 'name'))) );
			
			$personaldataghana->appendChild( $dom->createElement('Sex', $this->getDesc($row['genderid'], 'gender_tb', 'name')));				
			$personaldataghana->appendChild( $dom->createElement('Height', isset($row['height'])?$row['height']:"" ));
			$personaldataghana->appendChild( $dom->createElement('EyeColor', strtolower($this->getDesc($row['eyecolorid'], 'color_eye_tb', 'name'))) );
			$personaldataghana->appendChild( $dom->createElement('HairColor', strtolower($this->getDesc($row['haircolorid'], 'color_hair_tb', 'name'))) ); //strtolower($row[''])) );
			$personaldataghana->appendChild( $dom->createElement('VisiblePeculiarities', isset($row['peculiarity'])?strtoupper($row['peculiarity']):"") );
			
			
			$personaldataghana->appendChild( $dom->createElement('Nationality', ucfirst($this->getDesc($row['nationalityid'], 'country_tb', 'nationality'))) ); 
			$personaldataghana->appendChild( $dom->createElement('MaritalStatus', strtolower($this->getDesc($row['maritalstatusid'], 'marital_status_tb', 'name'))) ); //strtolower($row['maritalstatus'])) );
			$personaldataghana->appendChild( $dom->createElement('Profession', strtolower($this->getDesc($row['professionid'], 'profession_tb', 'professiondesc'))) );//strtoupper($row['professionid'])) );
			
			$personaldataghana->appendChild( $dom->createElement('PreviousProfession', strtolower($this->getDesc($row['previousprofessionid'], 'profession_tb', 'professiondesc'))) );//strtoupper($row['previousprofessionid'])) );
			 
			$personaldataghana->appendChild( $dom->createElement('NationalIdCardNumber', isset($row['nationalidentityno'])?strtoupper($row['nationalidentityno']):"") );
			$personaldataghana->appendChild( $dom->createElement('SocialSecurityNumber', isset($row['ssnitno'])?strtoupper($row['ssnitno']):"") );
			$personaldataghana->appendChild( $dom->createElement('VotersIdCardNumber', isset($row['voterid'])?strtoupper($row['voterid']):"") );
			$personaldataghana->appendChild( $dom->createElement('PreviousPassportNumber', isset($row['previouspassportnumber'])?strtoupper($row['previouspassportnumber']):"") );
			
			//Applicant Residence Address
			$residence = $dom->createElement('Residence');
			$residence->appendChild( $dom->createElement('Country', strtoupper($this->getDesc($row['residencecountryid'], 'country_tb', 'name'))) );//strtoupper($row['residencecountryid'])) );
			$residence->appendChild( $dom->createElement('City', isset($row['residencecity'])?strtoupper($row['residencecity']):"") );
			$residence->appendChild( $dom->createElement('ZipCode', isset($row['residencezipcode'])?strtoupper($row['residencezipcode']):"") );
			$residence->appendChild( $dom->createElement('Suburb', isset($row['residencesuburb'])?strtoupper($row['residencesuburb']):"") );
			$residence->appendChild( $dom->createElement('StreetAndHouseNumber', isset($row['residencehouseno'])?strtoupper($row['residencehouseno']):"") );			
			$residence->appendChild( $dom->createElement('ResidentialPhoneNumber', isset($row['residencetel'])?strtoupper($row['residencetel']):"") );
			$personaldataghana->appendChild($residence);
			
			$personaldataghana->appendChild( $dom->createElement('PostalAddress', isset($row['residencepostaladdress'])?strtoupper($row['residencepostaladdress']):""));
			$personaldataghana->appendChild( $dom->createElement('PhoneNumber', isset($row['cellphone'])?strtoupper($row['cellphone']):"") );
			$personaldataghana->appendChild( $dom->createElement('EMail', isset($row['residencepostemail'])?strtoupper($row['residencepostemail']):"") );
			
			
			//Educational Institution 
			$educationalinstitution = $dom->createElement('EducationalInstitution');
			$educationalinstitution->appendChild( $dom->createElement('Institution', isset($row['institution'])?strtoupper($row['institution']):"") );
			$educationalinstitution->appendChild( $dom->createElement('Address', isset($row['institutionpostaladdress'])?strtoupper($row['institutionpostaladdress']):"") );
			$educationalinstitution->appendChild( $dom->createElement('FromDate', isset($row['institutionperiodfrom'])?strtoupper($row['institutionperiodfrom']):"") );
			$educationalinstitution->appendChild( $dom->createElement('ToDate', isset($row['institutionperiodto'])?strtoupper($row['institutionperiodto']):"") );
			$personaldataghana->appendChild($educationalinstitution);
			
			///////////////////
			//Evidence of Citizenship
			$evidenceofcitizenship = $dom->createElement('EvidenceOfCitizenship'); 
			
			//Father
			$father = $dom->createElement('Father');
			$father->appendChild( $dom->createElement('Name', isset($row['fathername'])?strtoupper($row['fathername']):"" ) );
			$father->appendChild( $dom->createElement('Nationality', strtoupper($this->getDesc($row['fathernationalityid'], 'country_tb', 'nationality'))) );//strtoupper($row['fathernationalityid'])) );
			$father->appendChild( $dom->createElement('Living', isset($row['fatherlivingid'])&&$row['fatherlivingid']?"true":"false") );
			$father->appendChild( $dom->createElement('PostalAddress', isset($row['fatherpostaladdress'])?strtoupper($this->__filterStr($row['fatherpostaladdress'])):"") );
			$father->appendChild( $dom->createElement('ResidentialAddress', isset($row['fatherresidentialaddress'])?strtoupper($this->__filterStr($row['fatherresidentialaddress'])):"") );
			$father->appendChild( $dom->createElement('HomeTown', isset($row['fatherhometown'])?strtoupper($row['fatherhometown']):"" ) );
			$father->appendChild( $dom->createElement('PhoneNumber', isset($row['fatherphone'])?strtoupper($row['fatherphone']):"" ) );
			$father->appendChild( $dom->createElement('EMail', isset($row['fatheremail'])?strtoupper($row['fatheremail']):"" ) );
			$evidenceofcitizenship->appendChild($father);
			
				
			//Mother
			$mother = $dom->createElement('Mother');
			$mother->appendChild( $dom->createElement('Name', isset($row['mothername'])?strtoupper($row['mothername']):""  ) );
			$mother->appendChild( $dom->createElement('Nationality', strtoupper($this->getDesc($row['mothernationalityid'], 'country_tb', 'nationality'))) );//strtoupper($row['mothernationalityid'])) );
			$mother->appendChild( $dom->createElement('Living', isset($row['motherlivingid'])&&$row['motherlivingid']?"true":"false") );
			$mother->appendChild( $dom->createElement('PostalAddress', isset($row['motherpostaladdress'])?strtoupper($this->__filterStr($row['motherpostaladdress'])):"") );
			$mother->appendChild( $dom->createElement('ResidentialAddress', isset($row['motherresidentialaddress'])?strtoupper($this->__filterStr($row['motherresidentialaddress'])):"" ) );
			$mother->appendChild( $dom->createElement('HomeTown', isset($row['motherhometown'])?strtoupper($row['motherhometown']):"" ) );
			$mother->appendChild( $dom->createElement('PhoneNumber', isset($row['motherphone'])?strtoupper($row['motherphone']):"" ) );
			$mother->appendChild( $dom->createElement('EMail', isset($row['motheremail'])?strtoupper($row['motheremail']):"" ) );		
			$evidenceofcitizenship->appendChild($mother);
			
			//grandparent
			$grandparents = $dom->createElement('GrandParents');
			$grandparents->appendChild( $dom->createElement('Name', isset($row['grandname'])?strtoupper($row['grandname']):""  ) );
			$grandparents->appendChild( $dom->createElement('Nationality', strtoupper($this->getDesc($row['grandnationalityid'], 'country_tb', 'nationality'))) );//strtoupper($row['mothernationalityid'])) );
			$grandparents->appendChild( $dom->createElement('Living', isset($row['grandlivingid'])&&$row['grandlivingid']?"true":"false") );
			$grandparents->appendChild( $dom->createElement('PostalAddress', isset($row['grandpostaladdress'])?strtoupper($this->__filterStr($row['grandpostaladdress'])):"") );			
			$grandparents->appendChild( $dom->createElement('ResidentialAddress', isset($row['grandresidentialaddress'])?strtoupper($this->__filterStr($row['grandresidentialaddress'])):"" ) );
			$grandparents->appendChild( $dom->createElement('HomeTown', isset($row['grandhometown'])?strtoupper($row['grandhometown']):"" ) );			
			$grandparents->appendChild( $dom->createElement('PhoneNumber', isset($row['grandphone'])?strtoupper($row['grandphone']):"" ) );
			$grandparents->appendChild( $dom->createElement('EMail', isset($row['grandemail'])?strtoupper($row['grandemail']):"" ) );
			
			$evidenceofcitizenship->appendChild($grandparents);
			
			//Dual Citizenship
			$evidenceofcitizenship->appendChild( $dom->createElement('DualCitizenship', isset($row['dualcitizenid'])&&$row['dualcitizenid']?"true":"false") );
			
			$evidenceofcitizenship->appendChild( $dom->createElement('DualCitizenshipCountry', strtolower($this->getDesc($row['dualcountryid'], 'country_tb', 'name'))) );
			
			//Attach nodes - application
			$personaldataghana->appendChild( $evidenceofcitizenship );
			
			////////////////////////////////			
			$personaldataghana->appendChild( $dom->createElement('DocumentOwner', 'false') );
			
			//CurrentDocument 
			$currentdocument = $dom->createElement('CurrentDocument');
			$currentdocument->appendChild( $dom->createElement('DocumentType', strtolower($this->getDesc($row['documenttypeid'], 'nationaldocument_tb', 'name'))) );
			$currentdocument->appendChild( $dom->createElement('number', isset($row['documentnumber'])?strtoupper($row['documentnumber']):"")  );
			$currentdocument->appendChild( $dom->createElement('DateOfIssue', isset($row['documentdateissued'])?strtoupper($this->__date($row['documentdateissued'])):"") );
			$currentdocument->appendChild( $dom->createElement('PlaceOfIssue', isset($row['documentplaceissued'])?strtoupper($row['documentplaceissued']):"") );
			//$currentdocument->appendChild( $dom->createElement('LostOrStolen', '' ));
			
			//Attached Documents
			$currentdocument->appendChild( $dom->createElement('BirthCertificate', isset($row['birthcertificate'])?"YES":"NO") );
			$currentdocument->appendChild( $dom->createElement('NationalIdentityCard', isset($row['nationalidentitycard'])?"YES":"NO") );
			$currentdocument->appendChild( $dom->createElement('OldPassport', isset($row['oldpassport'])?"YES":"NO") );
			$currentdocument->appendChild( $dom->createElement('VoterIdCard', isset($row['votercard'])?"YES":"NO") );
			$currentdocument->appendChild( $dom->createElement('DualCitizenCard', isset($row['dualcitizenshipcard'])?"YES":"NO") );
			$currentdocument->appendChild( $dom->createElement('NaturalizationCard', isset($row['naturalisationcard'])?"YES":"NO") );		
			$currentdocument->appendChild( $dom->createElement('RegistrationCard', isset($row['registrationcard'])?"YES":"NO") );
			
			//CurrentDocument node to application element
			$personaldataghana->appendChild( $currentdocument );	
			
			//Gurantors 1
			$gurantors1 = $dom->createElement('Guarantor1'); 
			$gurantors1->appendChild( $dom->createElement('Name', isset($row['guarantor1name'])?strtoupper($row['guarantor1name']):"") );
			$gurantors1->appendChild( $dom->createElement('ResidentialAddress', isset($row['guarantor1residentialaddress'])?strtoupper($this->__filterStr($row['guarantor1residentialaddress'])):"") );	
			$gurantors1->appendChild( $dom->createElement('PostalAddress', isset($row['guarantor1postaladdress'])?strtoupper($this->__filterStr($row['guarantor1postaladdress'])):"") );		//	) );strtoupper($row['guarantor1postaladdress'])
			$gurantors1->appendChild( $dom->createElement('PhoneNumber', isset($row['guarantor1phone'])?strtoupper($row['guarantor1phone']):"") );		//	 ) );$row['guarantor1phone']
			$gurantors1->appendChild( $dom->createElement('Occupation',  strtolower($this->getDesc($row['guarantor1occupationid'], 'profession_tb', 'professiondesc'))) );//strtoupper($row['guarantor1occupation'])) );
			$gurantors1->appendChild( $dom->createElement('EMail', isset($row['guarantor1email'])?strtoupper($row['guarantor1email']):"" ) );
			$gurantors1->appendChild( $dom->createElement('SignatureDate', $this->__date($row['creationdate'])) );
			
			//Gurantors 1 - CurrentDocument
			$currentdocument1 = $dom->createElement('CurrentDocument');
			$currentdocument1->appendChild( $dom->createElement('number', '') );
			$currentdocument1->appendChild( $dom->createElement('placeOfIssue', '') );
			$currentdocument1->appendChild( $dom->createElement('lostOrStolen', '') );

			//Attach CurrentDocument1 node to gurantors1
			$gurantors1->appendChild($currentdocument1);
			
			//Attach gurantors1 node to application element
			$personaldataghana->appendChild( $gurantors1 );			
			
			//Gurantors 2
			$gurantors2 = $dom->createElement('Guarantor2');
			$gurantors2->appendChild( $dom->createElement('Name', isset($row['guarantor2name'])?strtoupper($row['guarantor2name']):"") );
			$gurantors2->appendChild( $dom->createElement('ResidentialAddress', isset($row['guarantor2residentialaddress'])?strtoupper($this->__filterStr($row['guarantor2residentialaddress'])):"") );	
			$gurantors2->appendChild( $dom->createElement('PostalAddress', isset($row['guarantor2postaladdress'])?strtoupper($this->__filterStr($row['guarantor2postaladdress'])):"") );		//	) );strtoupper($row['guarantor1postaladdress'])
			$gurantors2->appendChild( $dom->createElement('PhoneNumber', isset($row['guarantor2phone'])?strtoupper($row['guarantor2phone']):"") );
			$gurantors2->appendChild( $dom->createElement('Occupation', strtolower($this->getDesc($row['guarantor2occupationid'], 'profession_tb', 'professiondesc'))) );//strtoupper($row['guarantor2occupation'])));
			$gurantors2->appendChild( $dom->createElement('EMail', isset($row['guarantor2email'])?strtoupper($row['guarantor2email']):"" ) );
			$gurantors2->appendChild( $dom->createElement('SignatureDate', $this->__date($row['creationdate'])) );
			
			//Gurantors 2 - CurrentDocument
			$currentdocument2 = $dom->createElement('CurrentDocument');
			$currentdocument2->appendChild( $dom->createElement('number', '') );
			$currentdocument2->appendChild( $dom->createElement('placeOfIssue', '') );
			$currentdocument2->appendChild( $dom->createElement('lostOrStolen', '') );
			
			//Attach CurrentDocument1 node to gurantors1
			$gurantors2->appendChild($currentdocument2);
			
			//Attach gurantors1 node to application element
			$personaldataghana->appendChild( $gurantors2 );
							
			//Witness
			$witness = $dom->createElement('Witness');
			$witness->appendChild( $dom->createElement('Name', isset($row['witnessfname'])?strtoupper($row['witnessfname']):"") );
			$witness->appendChild( $dom->createElement('Occupation', isset($row['witnessoccupationid'])?strtoupper($this->getDesc($row['witnessoccupationid'], 'witnessprofession_tb', 'name')):"") );			
			$witness->appendChild( $dom->createElement('Position', isset($row['witnessposition'])?strtoupper($row['witnessposition']):"") );
			$witness->appendChild( $dom->createElement('BusinessAddress', isset($row['witnessbusinessaddress'])?strtoupper($row['witnessbusinessaddress']):"") );
			$witness->appendChild( $dom->createElement('BusinessPhoneNumber', isset($row['witnessphone'])?strtoupper($row['witnessphone']):"") );		
			$witness->appendChild( $dom->createElement('ResidentialAddress', isset($row['witnessresidentialaddress'])?strtoupper($row['witnessresidentialaddress']):"") );
			$witness->appendChild( $dom->createElement('ResidentialPhoneNumber', isset($row['witnessphone'])?strtoupper($row['witnessphone']):"") );
			$witness->appendChild( $dom->createElement('SignatureDate', $this->__date($row['creationdate'])) );
			
			//Attach Witness node to application element
			$personaldataghana->appendChild( $witness );

			//Declaration
			$declaration = $dom->createElement('Declaration');
			$declaration->appendChild( $dom->createElement('Name', isset($row['decapplicantfullname'])?strtoupper($row['decapplicantfullname']):"") );
			$declaration->appendChild( $dom->createElement('PhoneNumber', '') );
			
			$currentdocument3 = $dom->createElement('CurrentDocument');
			$currentdocument3->appendChild( $dom->createElement('number', isset($row['decpassportno'])?strtoupper($row['decpassportno']):"") );
			$currentdocument3->appendChild( $dom->createElement('placeOfIssue', '') );
			$currentdocument3->appendChild( $dom->createElement('lostOrStolen', isset($row['decattachlost'])&&$row['decattachlost']==0?"ATTACHED":"LOST") );
			$currentdocument3->appendChild( $dom->createElement('DateOfIssue', isset($row['dateofissue'])?$this->__date($row['dateofissue']):"" ));

			$declaration->appendChild( $currentdocument3 );
			
			//Attach Witness node to application element
			$personaldataghana->appendChild( $declaration );
			
			//Legal Guardian
			$legalguardian = $dom->createElement('LegalGuardian'); //
			$legalguardian->appendChild( $dom->createElement('Relationship', isset($row['legalrelation'])?strtoupper($row['legalrelation']):"") );
			$legalguardian->appendChild( $dom->createElement('Name', isset($row['legalname'])?strtoupper($row['legalname']):"") );
			$legalguardian->appendChild( $dom->createElement('Address', isset($row['legaladdress'])?strtoupper($row['legaladdress']):"") );//str_replace('&#13;',' ',$row['residencepostaladdress'])
			$legalguardian->appendChild( $dom->createElement('PhoneNumber', isset($row['legalphone'])?strtoupper($row['legalphone']):"") );
			$legalguardian->appendChild( $dom->createElement('SignatureDate', $this->__date($row['creationdate'])) );
			
			$personaldataghana->appendChild( $legalguardian );
			
			//Translator
			$translator = $dom->createElement('Translator');
			$translator->appendChild( $dom->createElement('OtherLanguage', isset($row['onbehalflanguage'])?strtoupper($row['onbehalflanguage']):"") );
			$translator->appendChild( $dom->createElement('Name', isset($row['onbehalfname'])?strtoupper($row['onbehalfname']):"") );
			$translator->appendChild( $dom->createElement('Address', isset($row['onbehalfaddress'])?strtoupper($row['onbehalfaddress']):"") );
			$translator->appendChild( $dom->createElement('PhoneNumber', isset($row['onbehalfphone'])?strtoupper($row['onbehalfphone']):"") );
			$translator->appendChild( $dom->createElement('SignatureDate', $this->__date($row['creationdate'])) );
			
			$personaldataghana->appendChild( $translator );
			
			//Application Location & Validity
			$personaldataghana->appendChild( $dom->createElement('PlaceOfIssue', strtoupper($this->getDesc($row['consularid'], 'consular_tb', 'consularname'))  ));
			// $personaldataghana->appendChild( $dom->createElement('PlaceOfIssue', strtoupper($this->site) ));
			$personaldataghana->appendChild( $dom->createElement('ValidityInMonths', $this->period) );//60 - 5years
			
			//ApplicationForm
			$applicationform = $dom->createElement('ApplicationForm');//DateOfIssue 
			$applicationform->appendChild( $dom->createElement('FormNumber', $row['refno']) );
			$applicationform->appendChild( $dom->createElement('ReceiptNumber', isset($row['receiptno'])?$row['receiptno']:""));
			$applicationform->appendChild( $dom->createElement('ApplicationDate', $this->__date($row['creationdate'])) );
			$applicationform->appendChild( $dom->createElement('DeclarationDate', $this->__date($row['creationdate']) ));
			
			$applicationform->appendChild( $dom->createElement('ApplicationType', strtolower($this->getDesc($row['applicationcategoryid'], 'applicationcategory_tb', 'name'))));//$row['applicationcategoryid']) );//
			$applicationform->appendChild( $dom->createElement('RequestedPassportType', strtolower($this->getDesc($row['passporttypeid'], 'passporttype_tb', 'name'))));//$row['passporttypeid']) );
			$applicationform->appendChild( $dom->createElement('Priority', strtolower($this->getDesc($row['applicationpriorityid'], 'applicationpriority_tb', 'name'))));//$row['applicationpriorityid']) );
			
			//Attach ApplicationForm node to application element
			$personaldataghana->appendChild( $applicationform );
			
			$personaldataghana->appendChild( $dom->createElement('PrefetchedFromExternalSystem', 'true') );				
			/*//End of Application data */
			
			//Attach personaldataghana
			$application->appendChild( $personaldataghana );
			
			//child root node closure
			//$applications->appendChild( $application );
			return $application;
		}
		
		protected function getDesc($id, $tabname, $colname='name'){
			global $db;
			
			$sql = "SELECT * FROM $tabname WHERE deleted='0' AND id='$id'";
			
			$rs = $db->query($sql);
			//Execute on successful result
			
			if (!$rs->IsError() && $rs->size() ){	
		
				$row = $rs->fetch();
				
				return $this->__filterStr($row[$colname]);	
				
			}else return "";
						
		}
		
		private function __date($sDate){
			$date = new DateTime($sDate);
			return $date->format('Y-m-d');
		}
		
		private function __filterStr($str){
			return str_replace("&#13;", " ", $str);
		}
		
		///////////////////////////////////////
					//Dom declaration
		private function __noResult($outcomeVal){
			
			$dom = new DomDocument("1.0", "UTF-8");
				
			//parent node
			$result = $dom->createElement('result');
			
			$result->appendChild( $dom->createElement('outcome', $outcomeVal ));
			
			//Close DOM		
			$dom->appendChild( $result );
			
			return $dom->saveXML();
			//////////////////////////////////////
		}

		
		//Special Character Conversion
		private function sp(string $word) {

			$word = str_replace("@","%40",$word);
			$word = str_replace("`","%60",$word);
			$word = str_replace("¢","%A2",$word);
			$word = str_replace("£","%A3",$word);
			$word = str_replace("¥","%A5",$word);
			$word = str_replace("|","%A6",$word);
			$word = str_replace("«","%AB",$word);
			$word = str_replace("¬","%AC",$word);
			$word = str_replace("¯","%AD",$word);
			$word = str_replace("º","%B0",$word);
			$word = str_replace("±","%B1",$word);
			$word = str_replace("ª","%B2",$word);
			$word = str_replace("µ","%B5",$word);
			$word = str_replace("»","%BB",$word);
			$word = str_replace("¼","%BC",$word);
			$word = str_replace("½","%BD",$word);
			$word = str_replace("¿","%BF",$word);
			$word = str_replace("À","%C0",$word);
			$word = str_replace("Á","%C1",$word);
			$word = str_replace("Â","%C2",$word);
			$word = str_replace("Ã","%C3",$word);
			$word = str_replace("Ä","%C4",$word);
			$word = str_replace("Å","%C5",$word);
			$word = str_replace("Æ","%C6",$word);
			$word = str_replace("Ç","%C7",$word);
			$word = str_replace("È","%C8",$word);
			$word = str_replace("É","%C9",$word);
			$word = str_replace("Ê","%CA",$word);
			$word = str_replace("Ë","%CB",$word);
			$word = str_replace("Ì","%CC",$word);
			$word = str_replace("Í","%CD",$word);
			$word = str_replace("Î","%CE",$word);
			$word = str_replace("Ï","%CF",$word);
			$word = str_replace("Ð","%D0",$word);
			$word = str_replace("Ñ","%D1",$word);
			$word = str_replace("Ò","%D2",$word);
			$word = str_replace("Ó","%D3",$word);
			$word = str_replace("Ô","%D4",$word);
			$word = str_replace("Õ","%D5",$word);
			$word = str_replace("Ö","%D6",$word);
			$word = str_replace("Ø","%D8",$word);
			$word = str_replace("Ù","%D9",$word);
			$word = str_replace("Ú","%DA",$word);
			$word = str_replace("Û","%DB",$word);
			$word = str_replace("Ü","%DC",$word);
			$word = str_replace("Ý","%DD",$word);
			$word = str_replace("Þ","%DE",$word);
			$word = str_replace("ß","%DF",$word);
			$word = str_replace("à","%E0",$word);
			$word = str_replace("á","%E1",$word);
			$word = str_replace("â","%E2",$word);
			$word = str_replace("ã","%E3",$word);
			$word = str_replace("ä","%E4",$word);
			$word = str_replace("å","%E5",$word);
			$word = str_replace("æ","%E6",$word);
			$word = str_replace("ç","%E7",$word);
			$word = str_replace("è","%E8",$word);
			$word = str_replace("é","%E9",$word);
			$word = str_replace("ê","%EA",$word);
			$word = str_replace("ë","%EB",$word);
			$word = str_replace("ì","%EC",$word);
			$word = str_replace("í","%ED",$word);
			$word = str_replace("î","%EE",$word);
			$word = str_replace("ï","%EF",$word);
			$word = str_replace("ð","%F0",$word);
			$word = str_replace("ñ","%F1",$word);
			$word = str_replace("ò","%F2",$word);
			$word = str_replace("ó","%F3",$word);
			$word = str_replace("ô","%F4",$word);
			$word = str_replace("õ","%F5",$word);
			$word = str_replace("ö","%F6",$word);
			$word = str_replace("÷","%F7",$word);
			$word = str_replace("ø","%F8",$word);
			$word = str_replace("ù","%F9",$word);
			$word = str_replace("ú","%FA",$word);
			$word = str_replace("û","%FB",$word);
			$word = str_replace("ü","%FC",$word);
			$word = str_replace("ý","%FD",$word);
			$word = str_replace("þ","%FE",$word);
			$word = str_replace("ÿ","%FF",$word);
			return $word;
		}
		
	}
