<?php
    // Get the contents of the JSON file 
    $define_boot     = file_get_contents(dirname(__FILE__)."../../boot/config.boot.api.json");

    // Convert to array 
    $config_bt = json_decode($define_boot, true);

    $portal             = $config_bt['boot']['server']['portal'];
    $domain             = $config_bt['boot']['server']['domain'];

    $enviromentLive     = $config_bt['boot']['switch']['isProductionServerLive'];
    $is_Local_AuthOn    = $config_bt['boot']['is_Local_AuthOn'];
    $countrycode        = $config_bt['boot']['mission']['countrycode'];
    $mission            = $config_bt['boot']['mission']['city'];
    $period             = $config_bt['boot']['passport']['period'];

    $db_location        = $config_bt['boot']['db']['location'];
    $db_prefix          = $config_bt['boot']['db']['prefix'];
    $shared_doc_root    = $config_bt['boot']['db']['shared-doc-root'];
    $isRemoteDb         = $config_bt['boot']['db']['is-remote-db'];

    $uri		        = $enviromentLive ? "https://www.{$domain}/api/{$mission}" : "http://localhost/api/{$mission}";
    // $uri		        = $enviromentLive ? "https://www.ghanagovernmentmission.net/api/{$mission}" : "http://localhost/api/{$mission}";

    // $define_timezone    = file_get_contents(__DIR__."../../../../var/shared/json/timezone/{$mission}.time.json");

    $define_timezone    = $enviromentLive? 
                            file_get_contents("/{$shared_doc_root}/var/shared/json/timezone/{$mission}.time.json") : 
                            file_get_contents(__DIR__."../../../../var/shared/json/timezone/{$mission}.time.json")  ;


    $config_tz          = json_decode($define_timezone, true);
    $timezone           = $config_tz['timezone']['city'];

    //Define DB
    $db_live            = "{$db_prefix}_visa_{$mission}_live_db"; 
    // $db_live         = "ggm_visa_{$mission}_live_db"; 
    $db_test            = "visa_{$mission}_db";           

    //Define Location Timezone
    define('TIMEZONE', $timezone);  
    date_default_timezone_set(TIMEZONE);  

    //Defined system environment constants
    define ('LIVE',	    $enviromentLive);	
    define ('SITE',     $mission);
    define ('PERIOD',   $period);	
    define ('ISLOCALAUTHON',  $is_Local_AuthOn);	
    define ('DB_LIVE',  $db_live);	
    define ('DB_TEST',  $db_test);	
    define ('URI',      $uri);	

    define ('SHARED_DOC_ROOT',    $shared_doc_root);	
    define ('DB_PREFIX',    $db_prefix);	
    define ('DB_REMOTE',    $isRemoteDb);	

    define("__SHARED_LIVE_ROOT__", 	"/{$shared_doc_root}/var/shared/json");