<?php
	// disabling WSDL cache
	ini_set("soap.wsdl_cache_enabled", "0"); 

	require_once (dirname(__FILE__).'/env/env.php');
	require_once (dirname(__FILE__).'/../common/model/model.api.class.php');
	
	global $darkwaa;

	class AuthException extends Exception { }
	class MthException extends Exception { }

	//Get param	
	$refno 		= $_GET['ReferenceId']	?? $_POST['ReferenceId'] 	?? "";
	$func		= $_GET['func']			?? $_POST['func']			?? "";
	$documentId = $_GET['documentId']	?? $_POST['documentId']		?? "";
	$status 	= $_GET['Status']		?? $_GET['Status']			?? "";
	$remarks 	= $_GET['Remarks']		?? $_GET['Remarks']			?? "";

	//Sanitize
	$refno 		= $darkwaa->clean($refno);
	$func 		= $darkwaa->clean($func);
	$documentId = $darkwaa->clean($documentId);
	$status 	= $darkwaa->clean($status);
	$remarks 	= $darkwaa->clean($remarks);

	//Authentication Parameters
	$args = [
		"api_key" 			=> $_GET['api_key'] ?? $_POST['api_key'] ?? $darkwaa->badToken,
		"is_Local_AuthOn" 	=> ISLOCALAUTHON 
	];
	
	$wsdl		= "wsdl/passportClassWS.wsdl";
	$uri		= URI;
	$Location 	= $uri.'/server.php'; 

	//////////////Instantiate Class/////////////
	try{
		///////////////////////////////////////////////////////////////////////////////////	
		$client = new SoapClient($uri."/".$wsdl, array("location"    => $Location,
														"trace"	  	 => 1,
														"exceptions" => 1)
								);
				
		//Verify API User
		if( !$darkwaa->verifyAPIUser($args) ) throw new AuthException ("Authentication Error, invalid API key. Please contact the System Administrator.");
		else{

			//set paramenter
			switch($func){
					
				default:
					throw new MthException ("===> {$func}. Please contact the System Administrator.");
					break;

				case 'getAllCompleted'://
					$param 	= array();
					$result = $client->__soapCall("getAllCompleted", array($param));
					break;
					
				// case 'getEnrolmentMobilePackData'://
				// 	//Inputs
				// 	$param = array("ReferenceId" =>$refno);
				// 	$result = $client->__soapCall("getEnrolmentMobilePackData", array($param));
				// 	break;

				case 'getEnrolmentData'://
					//Inputs
					$param = array("ReferenceId" => $refno);
					$result = $client->__soapCall("getEnrolmentData", array($param));
					break;
					
				case 'getScannedDocuments'://
					$param 	= array("ReferenceId" => $refno, "documentId" => $documentId);
					$result = $client->__soapCall("getScannedDocuments", array($param));
					break;
				
				case 'updateEnrolmentStatus'://
					$param 	= array("ReferenceId" => $refno, "Status" => $status, "Remarks" => $remarks);
					$result = $client->__soapCall("updateEnrolmentStatus", array($param));
					break; 
			}
			
			//Check for error
			if (is_soap_fault($result)) trigger_error("SOAP Fault: (faultcode: {$result->faultcode}, faultstring: {$result->faultstring})", E_USER_ERROR);
			
			//Output
			header("Content-type: text/xml");

			//Send Output
			echo $result->return; 
		}

	}catch (SoapFault $vException){
		echo "Client Error:<br />" .nl2br($vException->faultcode).'<br /><br />Error Details:<br />'.nl2br($vException->faultstring).'<br />';
								   
		echo("<br />REQUEST :<br />" .htmlspecialchars($client->__getLastRequest())."<br />");
		echo("<br />RESPONSE:<br />" .htmlspecialchars($client->__getLastResponse())."<br />");
	
	}catch (AuthException $e){

		echo "Error: ".$e->getMessage();

	}catch (MthException $e){

		echo "Error: ".$e->getMessage();
		
	}